Imports System.Collections

'
' Instances of this class build a table of contents
'
Friend Class TocVisitor
    Inherits DocumentVisitor
    Private tocStyles As New Hashtable()

    Friend Sub New(ByVal document As Document)
        MyBase.New(document)
        Dim levels As TocLevel() = document.TocLevels
        ' put styles in a hashtable.
        For i As Integer = 0 To levels.Length - 1
            tocStyles(levels(i).Style) = levels(i)
        Next i
    End Sub 'New

    Friend Function BuildToc() As Toc
        Dim toc As New Toc()
        Dim p As Paragraph
        p = NextParagraph
        While p IsNot Nothing
            Dim styleName As String = p.Style
            If styleName IsNot Nothing Then
                Dim level As TocLevel = CType(tocStyles(styleName), TocLevel)
                If level IsNot Nothing Then
                    Dim firstLine As LineOfText = Nothing
                    For i As Integer = 0 To p.Count - 1
                        Dim e As IDocumentElement = p.GetChild(i)
                        If TypeOf e Is LineOfText Then
                            firstLine = CType(e, LineOfText)
                            Exit For
                        End If
                    Next i
                End If
            End If
            p = NextParagraph
        End While
        Return toc
    End Function 'BuildToc
End Class 'TocVisitor
